crit_events = faudes.Alphabet()

print("Import nominal models ...")
print("actuators")
ln_act_no_red = faudes.Generator("data/fa_ln_act_no_redundancy.gen")
ln_act_red = faudes.Generator("data/fa_ln_act_redundancy.gen")
ln_act_var = faudes.Generator("data/fa_ln_act_various.gen")
print("sensors")
ln_sen_no_red = faudes.Generator("data/fa_ln_sen_no_redundancy.gen")
ln_sen_red = faudes.Generator("data/fa_ln_sen_redundancy.gen")
ln_sen_var = faudes.Generator("data/fa_ln_sen_various.gen")
print("... done.")

print()
print("Construct Ld for the fault-case: 'Permanent Actuator Breakdown'...")

print("test data: simple machine without redundancy")
crit_events:Insert("ACT")
ld_act_no_red_permanent = faudes.Generator()
lf_act_no_red_permanent = faudes.Generator()
faudes.FtcPermanentBreakdown(ln_act_no_red,crit_events,ld_act_no_red_permanent)
faudes.LanguageUnion(ln_act_no_red,ld_act_no_red_permanent,lf_act_no_red_permanent)
lf_act_no_red_permanent:SetDefaultStateNames()
FAUDES_TEST_DUMP("Permanent Breakdwon no redudancy",ld_act_no_red_permanent)
crit_events:Clear()

print("test data: simple machine with redundancy")
crit_events:Insert("ACT1")
ld_act_red_permanent = faudes.Generator()
lf_act_red_permanent = faudes.Generator()
faudes.FtcPermanentBreakdown(ln_act_red,crit_events,ld_act_red_permanent)
faudes.LanguageUnion(ln_act_red,ld_act_red_permanent,lf_act_red_permanent)
lf_act_red_permanent:SetDefaultStateNames()
FAUDES_TEST_DUMP("Permanent Breakdwon redudancy",ld_act_red_permanent)
crit_events:Clear()

print("test data: simple machine with various actuators")
crit_events:Insert("ACT1")
crit_events:Insert("ACT2")
ld_act_var_permanent = faudes.Generator()
lf_act_var_permanent = faudes.Generator()
faudes.FtcPermanentBreakdown(ln_act_var,crit_events,ld_act_var_permanent)
faudes.LanguageUnion(ln_act_var,ld_act_var_permanent,lf_act_var_permanent)
lf_act_var_permanent:SetDefaultStateNames()
FAUDES_TEST_DUMP("Permanent Breakdwon various",ld_act_var_permanent)
crit_events:Clear()

print("... done")

print()
print("Construct Ld/Lf for the fault-case: 'Recurrent Actuator Breakdown'...")

print("test data: simple machine without redundancy")
crit_events:Insert("ACT")
ld_act_no_red_recurrent = faudes.Generator()
lf_act_no_red_recurrent = faudes.Generator()
faudes.FtcRecurrentBreakdown(ln_act_no_red,crit_events,ld_act_no_red_recurrent)
faudes.LanguageUnion(ln_act_no_red,ld_act_no_red_recurrent,lf_act_no_red_recurrent)
lf_act_no_red_recurrent:SetDefaultStateNames()
FAUDES_TEST_DUMP("Recurrent Breakdown no redudancy",ld_act_no_red_recurrent)
crit_events:Clear()

print("test data: simple machine with redundancy")
crit_events:Insert("ACT1")
ld_act_red_recurrent = faudes.Generator()
lf_act_red_recurrent = faudes.Generator()
faudes.FtcRecurrentBreakdown(ln_act_red,crit_events,ld_act_red_recurrent)
faudes.LanguageUnion(ln_act_red,ld_act_red_recurrent,lf_act_red_recurrent)
lf_act_red_recurrent:SetDefaultStateNames()
FAUDES_TEST_DUMP("Recurrent Breakdown redudancy",ld_act_red_recurrent)
crit_events:Clear()

print("test data: simple machine with various actuators")
crit_events:Insert("ACT1")
crit_events:Insert("ACT2")
ld_act_var_recurrent = faudes.Generator()
lf_act_var_recurrent = faudes.Generator()
faudes.FtcRecurrentBreakdown(ln_act_var,crit_events,ld_act_var_recurrent)
faudes.LanguageUnion(ln_act_var,ld_act_var_recurrent,lf_act_var_recurrent)
lf_act_var_recurrent:SetDefaultStateNames()
FAUDES_TEST_DUMP("Recurrent Breakdown various",ld_act_var_recurrent)
crit_events:Clear()

print("... done")

print()
print("Construct Ld/Lf for the fault-case: 'Permanent Operation' ...")

print("test data: simple machine without redundancy")
crit_events:Insert("ACT")
ld_act_no_red_perop = faudes.Generator()
lf_act_no_red_perop = faudes.Generator()
faudes.FtcPermanentOperation(ln_act_no_red,crit_events,ld_act_no_red_perop)
faudes.LanguageUnion(ln_act_no_red,ld_act_no_red_perop,lf_act_no_red_perop)
lf_act_no_red_perop:SetDefaultStateNames()
FAUDES_TEST_DUMP("Permanent operation no redundancy",ld_act_no_red_perop)
crit_events:Clear()

print("test data: simple machine with redundancy")
crit_events:Insert("ACT1") 
ld_act_red_perop = faudes.Generator()
lf_act_red_perop = faudes.Generator()
faudes.FtcPermanentOperation(ln_act_red,crit_events,ld_act_red_perop)
faudes.LanguageUnion(ln_act_red,ld_act_red_perop,lf_act_red_perop)
lf_act_red_perop:SetDefaultStateNames()
FAUDES_TEST_DUMP("Permanent operation redundancy",ld_act_red_perop)
crit_events:Clear()

print("test data: simple machine with various actuators")
crit_events:Insert("ACT1")
crit_events:Insert("ACT2")
ld_act_var_perop = faudes.Generator()
lf_act_var_perop = faudes.Generator()
faudes.FtcPermanentOperation(ln_act_var,crit_events,ld_act_var_perop)
faudes.LanguageUnion(ln_act_var,ld_act_var_perop,lf_act_var_perop)
lf_act_var_perop:SetDefaultStateNames()
FAUDES_TEST_DUMP("Permanent operation various",ld_act_var_perop)
crit_events:Clear()

print("... done")

print()
print("Construct Ld/Lf for the sensor fault-case: 'Permanent Mute' ...")

print("test data: simple machine without redundancy")
crit_events:Insert("SNS")
ld_sen_no_red_permanent = faudes.Generator()
lf_sen_no_red_permanent = faudes.Generator()
faudes.FtcPermanentMute(ln_sen_no_red,crit_events,ld_sen_no_red_permanent)
faudes.LanguageUnion(ln_sen_no_red,ld_sen_no_red_permanent,lf_sen_no_red_permanent)
lf_sen_no_red_permanent:SetDefaultStateNames()
FAUDES_TEST_DUMP("Permanent mute no redundancy",ld_sen_no_red_permanent)
crit_events:Clear()

print("test data: simple machine with redundancy")
crit_events:Insert("SNS1")
ld_sen_red_permanent = faudes.Generator()
lf_sen_red_permanent = faudes.Generator()
faudes.FtcPermanentMute(ln_sen_red,crit_events,ld_sen_red_permanent)
faudes.LanguageUnion(ln_sen_red,ld_sen_red_permanent,lf_sen_red_permanent)
lf_sen_red_permanent:SetDefaultStateNames()
FAUDES_TEST_DUMP("Permanent mute redundancy",ld_sen_red_permanent)
crit_events:Clear()

print("test data: simple machine with various actuators")
crit_events:Insert("SNS1")
crit_events:Insert("SNS2")
ld_sen_var_permanent = faudes.Generator()
lf_sen_var_permanent = faudes.Generator()
faudes.FtcPermanentMute(ln_sen_var,crit_events,ld_sen_var_permanent)
faudes.LanguageUnion(ln_sen_var,ld_sen_var_permanent,lf_sen_var_permanent)
lf_sen_var_permanent:SetDefaultStateNames()
FAUDES_TEST_DUMP("Permanent mute var",ld_sen_var_permanent)
crit_events:Clear()

print("... done")

print()
print("Construct Ld/Lf for the sensor fault-case: 'Recurrent Mute' ...")

print("test data: simple machine without redundancy")
crit_events:Insert("SNS")
ld_sen_no_red_recurrent = faudes.Generator()
lf_sen_no_red_recurrent = faudes.Generator()
faudes.FtcRecurrentMute(ln_sen_no_red,crit_events,ld_sen_no_red_recurrent)
faudes.LanguageUnion(ln_sen_no_red,ld_sen_no_red_recurrent,lf_sen_no_red_recurrent)
lf_sen_no_red_recurrent:SetDefaultStateNames()
FAUDES_TEST_DUMP("Recurrent mute no redundancy",ld_sen_no_red_recurrent)
crit_events:Clear()

print("test data: simple machine with redundancy")
crit_events:Insert("SNS1")
ld_sen_red_recurrent = faudes.Generator()
lf_sen_red_recurrent = faudes.Generator()
faudes.FtcRecurrentMute(ln_sen_red,crit_events,ld_sen_red_recurrent)
faudes.LanguageUnion(ln_sen_red,ld_sen_red_recurrent,lf_sen_red_recurrent)
lf_sen_red_recurrent:SetDefaultStateNames()
FAUDES_TEST_DUMP("Recurrent mute redundancy",ld_sen_red_recurrent)
crit_events:Clear()

print("test data: simple machine with various actuators")
crit_events:Insert("SNS1")
crit_events:Insert("SNS2")
ld_sen_var_recurrent = faudes.Generator()
lf_sen_var_recurrent = faudes.Generator()
faudes.FtcRecurrentMute(ln_sen_var,crit_events,ld_sen_var_recurrent)
faudes.LanguageUnion(ln_sen_var,ld_sen_var_recurrent,lf_sen_var_recurrent)
lf_sen_var_recurrent:SetDefaultStateNames()
FAUDES_TEST_DUMP("Recurrent mute various",ld_sen_var_recurrent)
crit_events:Clear()

print("... done")

print()
print("Construct Ld/Lf for the sensor fault-case: 'Random Trigger' ...")

print("test data: simple machine without redundancy")
crit_events:Insert("SNS")
ld_sen_no_red_trigger = faudes.Generator()
lf_sen_no_red_trigger = faudes.Generator()
faudes.FtcRandomTrigger(ln_sen_no_red,crit_events,ld_sen_no_red_trigger)
faudes.LanguageUnion(ln_sen_no_red,ld_sen_no_red_trigger,lf_sen_no_red_trigger)
lf_sen_no_red_trigger:SetDefaultStateNames()
FAUDES_TEST_DUMP("Random trigger no redundancy",ld_sen_no_red_trigger)
crit_events:Clear()

print("test data: simple machine with redundancy")
crit_events:Insert("SNS1")
ld_sen_red_trigger = faudes.Generator()
lf_sen_red_trigger = faudes.Generator()
faudes.FtcRandomTrigger(ln_sen_red,crit_events,ld_sen_red_trigger)
faudes.LanguageUnion(ln_sen_red,ld_sen_red_trigger,lf_sen_red_trigger)
lf_sen_red_trigger:SetDefaultStateNames()
FAUDES_TEST_DUMP("Random trigger redundancy",ld_sen_red_trigger)
crit_events:Clear()

print("test data: simple machine with various actuators")
crit_events:Insert("SNS1")
crit_events:Insert("SNS2")
ld_sen_var_trigger = faudes.Generator()
lf_sen_var_trigger = faudes.Generator()
faudes.FtcRandomTrigger(ln_sen_var,crit_events,ld_sen_var_trigger)
faudes.LanguageUnion(ln_sen_var,ld_sen_var_trigger,lf_sen_var_trigger)
lf_sen_var_trigger:SetDefaultStateNames()
FAUDES_TEST_DUMP("Random trigger various",ld_sen_var_trigger)
crit_events:Clear()

print("... done")

print()
print("Export generators... ")
ln_act_no_red:Write("tmp_ln_act_no_redundancy.gen")
ln_act_red:Write("tmp_ln_act_redundancy.gen")
ln_act_var:Write("tmp_ln_act_var.gen") 
ln_sen_no_red:Write("tmp_ln_sen_no_redundancy.gen")
ln_sen_red:Write("tmp_ln_sen_redundancy.gen")
ln_sen_var:Write("tmp_ln_sen_var.gen") 

ld_act_no_red_permanent:Write("tmp_ld_act_no_red_permanent_breakdown.gen")
ld_act_red_permanent:Write("tmp_ld_act_red_permanent_breakdown.gen")
ld_act_var_permanent:Write("tmp_ld_act_var_permanent_breakdown.gen")

ld_act_no_red_recurrent:Write("tmp_ld_act_no_red_recurrent_breakdown.gen")
ld_act_red_recurrent:Write("tmp_ld_act_red_recurrent_breakdown.gen")
ld_act_var_recurrent:Write("tmp_ld_act_var_recurrent_breakdown.gen")

ld_act_no_red_perop:Write("tmp_ld_act_no_red_permanent_operation.gen")
ld_act_red_perop:Write("tmp_ld_act_red_permanent_operation.gen")
ld_act_var_perop:Write("tmp_ld_act_var_permanent_operation.gen")

ld_sen_no_red_permanent:Write("tmp_ld_sen_no_red_permanent_breakdown.gen")
ld_sen_red_permanent:Write("tmp_ld_sen_red_permanent_breakdown.gen")
ld_sen_var_permanent:Write("tmp_ld_sen_var_permanent_breakdown.gen")

ld_sen_no_red_recurrent:Write("tmp_ld_sen_no_red_recurrent_breakdown.gen")
ld_sen_red_recurrent:Write("tmp_ld_sen_red_recurrent_breakdown.gen")
ld_sen_var_recurrent:Write("tmp_ld_sen_var_recurrent_breakdown.gen")

ld_sen_no_red_trigger:Write("tmp_ld_sen_no_red_arbitrary_trigger.gen")
ld_sen_red_trigger:Write("tmp_ld_sen_red_arbitrary_trigger.gen")
ld_sen_var_trigger:Write("tmp_ld_sen_var_arbitrary_trigger.gen")

lf_act_no_red_permanent:Write("tmp_lf_act_no_red_permanent_breakdown.gen")
lf_act_red_permanent:Write("tmp_lf_act_red_permanent_breakdown.gen")
lf_act_var_permanent:Write("tmp_lf_act_var_permanent_breakdown.gen")

lf_act_no_red_recurrent:Write("tmp_lf_act_no_red_recurrent_breakdown.gen")
lf_act_red_recurrent:Write("tmp_lf_act_red_recurrent_breakdown.gen")
lf_act_var_recurrent:Write("tmp_lf_act_var_recurrent_breakdown.gen")

lf_act_no_red_perop:Write("tmp_lf_act_no_red_permanent_operation.gen")
lf_act_red_perop:Write("tmp_lf_act_red_permanent_operation.gen")
lf_act_var_perop:Write("tmp_lf_act_var_permanent_operation.gen")

lf_sen_no_red_permanent:Write("tmp_lf_sen_no_red_permanent_breakdown.gen")
lf_sen_red_permanent:Write("tmp_lf_sen_red_permanent_breakdown.gen")
lf_sen_var_permanent:Write("tmp_lf_sen_var_permanent_breakdown.gen")

lf_sen_no_red_recurrent:Write("tmp_lf_sen_no_red_recurrent_breakdown.gen")
lf_sen_red_recurrent:Write("tmp_lf_sen_red_recurrent_breakdown.gen")
lf_sen_var_recurrent:Write("tmp_lf_sen_var_recurrent_breakdown.gen")

lf_sen_no_red_trigger:Write("tmp_lf_sen_no_red_arbitrary_trigger.gen")
lf_sen_red_trigger:Write("tmp_lf_sen_red_arbitrary_trigger.gen")
lf_sen_var_trigger:Write("tmp_lf_sen_var_arbitrary_trigger.gen")


print("...done")

-- 
-- check protocols
--
FAUDES_TEST_DIFF()