# libFAUDES - A Discrete-Event Systems Library



## Overview


libFAUDES is a C++ library that implements data structures for the representation 
of finite automata and algorithms for supervisory control within the framework 
originally proposed by P.J. Ramadge and W.M. Wonham. The library provides an 
implementation and evaluation basis for the further development of 
algorithms for the analysis and synthesis of DESs.

The core library sources are provided for free under conditions of the GNU Lesser 
General Public License.  Different terms may apply to libFAUDES plug-ins.




## Documentation

libFAUDES ships with auto-generated HTML documentaion which can be
accessed via ./doc/index.html. An online version is available at

https://fgdes.tf.fau.de/faudes

For your convenience, precompiled binaries are distributed at

https://fgdes.tf.fau.de/download.html

If you want to build your own, see the build process documentation

https://fgdes.tf.fau.de/faudes/faudes_build.html


## Versioning/Branching

Originally, libFAUDES was designed for joint development by its compile-time plug-in
machanism ... quite some time before Git existed. At the current stage, we
use the main branch of this repository for our development process. In modern terminology
this translates to <i>testing</i> and we would not even bother to update the
version number (as specified in the file `VERSION`). Thus, if you are looking for a stable
code base for your project, please consult our web site. If on the other hand you plan to contribute to libFAUDES
via GitHub, you will most definitely want to instantiate you personal branch. And: please
let us know, so we can focus our efforts.




## Authors/Copyright

libFAUDES is distributed under terms of the LGPL v2.1. Over time, many students and colleguous have contributed to the code base; see  https://fgdes.tf.fau.de/faudes for a complete list.

- Copyright (C) 2006, Bernd Opitz.
- Copyright (C) 2008 - 2010, Thomas Moor, Klaus Schmidt, Sebastian Perk. 
- Copyright (C) 2011 - 2025, Thomas Moor, Klaus Schmidt

