/** @file pd_alg_opt_test.cpp  Unit Tests */


/* Pushdown plugin for FAU Discrete Event Systems Library (libfaudes)

   Copyright (C) 2013  Stefan Jacobi, Sven Schneider, Anne-Kathrin Hess

*/
#include "pd_alg_opt_test.h"

namespace faudes {

/* *****************
 * TestRemoveUselessTransitionsNumberOfTransitions
 * *****************/
void TestRemoveUselessTransitionsNumberOfTransitions(){
  std::string name = "RemoveUselessTransitions Number of Transitions";
  TestStart(name);
  
  PushdownGenerator pd = TestGenerator21();
  
  PushdownGenerator rPd = RemoveUselessTransitions(pd);
  
  Idx s1 = pd.StateIndex("s1");
  Idx s2 = pd.StateIndex("s2");
  Idx square = pd.StackSymbolIndex("square");
  Idx dot = pd.StackSymbolIndex("dot");
  Idx lambda = pd.StackSymbolIndex(FAUDES_PD_LAMBDA);
  Idx a = pd.EventIndex("a");
  Idx b = pd.EventIndex("b");
  
  try{
    
    TransSet::Iterator transit;
    PopPushSet::const_iterator ppit;
    
    //number of transitions must be 4
    if(rPd.TransRelSize() != 4){
      std::stringstream errstr;
      errstr << "Number of transitions was expected to be 4, but was " << rPd.TransRelSize() << "." << std::endl;
      throw Exception(name, errstr.str(), 1003);
    }
    
    //test transition going out from s1
    for(transit = rPd.TransRelBegin(s1); transit != rPd.TransRelEnd(s1); transit++){
      
      //transition with event a must pop square
      if(transit->Ev == a){
        for(ppit = rPd.PopPushBegin(*transit); ppit != rPd.PopPushEnd(*transit); ppit++){
          
          //transition must pop square
          if(ppit->first.front() != square){
            std::stringstream errstr;
            errstr << "Transition originating at state s1 was expected to pop square, but popped " << rPd.StackSymbolName(ppit->first.front()) << "." << std::endl;
            throw Exception(name, errstr.str(), 1003);
          }
        }
      }
      
      //transition with event b must pop square
      if(transit->Ev == b){
        for(ppit = rPd.PopPushBegin(*transit); ppit != rPd.PopPushEnd(*transit); ppit++){
          
          //transition must pop square
          if(ppit->first.front() != square){
            std::stringstream errstr;
            errstr << "Transition originating at state s1 was expected to pop square, but popped " << rPd.StackSymbolName(ppit->first.front()) << "." << std::endl;
            throw Exception(name, errstr.str(), 1003);
          }
        }
      }
    }
    
    //test transitions going out from s2
    for(transit = rPd.TransRelBegin(s2); transit != rPd.TransRelEnd(s2); transit++){
      
      //transition with event a must pop dot
      if(transit->Ev == a){
        for(ppit = rPd.PopPushBegin(*transit); ppit != rPd.PopPushEnd(*transit); ppit++){
          
          //transition must pop dot
          if(ppit->first.front() != dot){
            std::stringstream errstr;
            errstr << "Transition originating at state s2 with event a was expected to pop dot, but popped " << rPd.StackSymbolName(ppit->first.front()) << "." << std::endl;
            throw Exception(name, errstr.str(), 1003);
          }
        }
      }
      //transition with event b must pop lambda
      if(transit->Ev == b){
        for(ppit = rPd.PopPushBegin(*transit); ppit != rPd.PopPushEnd(*transit); ppit++){
          
          //transition must pop lambda
          if(ppit->first.front() != lambda){
            std::stringstream errstr;
            errstr << "Transition originating at state s2 with event b was expected to pop lambda, but popped " << rPd.StackSymbolName(ppit->first.front()) << "." << std::endl;
            throw Exception(name, errstr.str(), 1003);
          }
        }
      }
    }
  }
  catch(Exception e){
  }
  
  TestEnd(name);
}

/* *****************
 * TestGetPossibleStackTopsFindCorrectOnes
 * *****************/
void TestGetPossibleStackTopsFindCorrectOnes(){
  
  std::string name = "TestGetPossibleStackTops Find Correct Ones Number";
  TestStart(name);
  
  PushdownGenerator pd = TestGenerator23();
  
  Idx dot = pd.StackSymbolIndex("dot");
  Idx heart= pd.StackSymbolIndex("heart");
  Idx diamond = pd.StackSymbolIndex("diamond");
  Idx square = pd.StackSymbolIndex("square");
  
  Idx s1 = pd.StateIndex("s1");
  Idx s2 = pd.StateIndex("s2");
  Idx s3 = pd.StateIndex("s3");
  
  StackSymbolSet::Iterator ssit;
  
  StackSymbolSet topS1 = GetPossibleStackTops(pd, StateSet(), s1);
  StackSymbolSet topS2 = GetPossibleStackTops(pd, StateSet(), s2);
  StackSymbolSet topS3 = GetPossibleStackTops(pd, StateSet(), s3);
  
  try{ 
    
    TransSet::Iterator transit;
    PopPushSet::const_iterator ppit;
    
    //test state 1, must contain square and diamond
    if(topS1.Size() != 2){
      std::stringstream errstr;
      errstr << "Number of possible stack top symbols of s1 was expected to be 2, but was " << topS1.Size() << "." << std::endl;
      throw Exception(name, errstr.str(), 1003);
    }
    if(!topS1.Exists(diamond)){
      std::stringstream errstr;
      errstr << "Stack symbol diamond was expected to be a possible stack top symbol of s1, but was not." << std::endl;
      throw Exception(name, errstr.str(), 1003);
    }
    if(!topS1.Exists(square)){
      std::stringstream errstr;
      errstr << "Stack symbol diamond was expected to be a possible stack top symbol of s1, but was not." << std::endl;
      throw Exception(name, errstr.str(), 1003);
    }
    //test state 2, must contain all symbols
    if(topS2.Size() != 4){
      std::stringstream errstr;
      errstr << "Number of possible stack top symbols of s2 was expected to be 4, but was " << topS2.Size() << "." << std::endl;
      throw Exception(name, errstr.str(), 1003);
    }
    //test state 2, must contain all symbols
    if(topS3.Size() != 4){
      std::stringstream errstr;
      errstr << "Number of possible stack top symbols of s3 was expected to be 4, but was " << topS3.Size() << "." << std::endl;
      throw Exception(name, errstr.str(), 1003);
    }
    

  }
  catch(Exception e){
  }
  
  TestEnd(name);
}
  
/* *****************
 * TestRemoveUselessTransitions
 * *****************/
void TestRemoveUselessTransitions(){
  TestRemoveUselessTransitionsNumberOfTransitions();
}

/* *****************
 * TestGetPossibleStackTops
 * *****************/
void TestGetPossibleStackTops(){
  TestGetPossibleStackTopsFindCorrectOnes();
}

} // namespace faudes

