/** @file pd_alg_nb_sub_b_test.h  Unit Tests */


/* Pushdown plugin for FAU Discrete Event Systems Library (libfaudes)

   Copyright (C) 2013  Stefan Jacobi, Sven Schneider, Anne-Kathrin Hess

*/

#ifndef FAUDES_PD_ALG_NB_SUB_B_TEST_H
#define FAUDES_PD_ALG_NB_SUB_B_TEST_H

#include "corefaudes.h"
#include "pd_include.h"
#include "pd_test_util.h"

namespace faudes {

/**
 * Test if all states were renamed correctly (merge attribute is set correctly).
 */
void TestRenQRenaming();

/**
 * Test if the number of states did not change.
 */
void TestRenQNumberOfStates();

/**
 * Test if all stack symbols were renamed correctly
 */
void TestRenGRenamingStackSymbols();

/**
 * Test if the number of stack symbols did not change.
 */
void TestRenGNumberOfStackSymbols();

/**
 * Test if the stack symbols in pop and push of transitions were changed correctly
 */
void TestRenGRenamingTransitions();

/**
 * Tests if there are any lambda popping edges left
 */
void TestRep0NoLambdaPop();

/**
 * Test if resulting generator has a transition able to pop all stack symbols,
 * but only if the orignal generator had at least one lambda transition
 */
void TestRep0AllExpectingTransition();

/**
 * Test for the right number of transitions and states in the generator after
 * applying Rep2
 */
void TestRep2NumberOfStatesTransitions();

/**
 * Tests if the MergeStateAnnotations have all been set to "old".
 */
void TestRep2Renaming();

/**
 * Test if all transitions are either read only, pop only or push only
 */
void TestRppReadPopPushOnly();
  
/**
 * Test if the number of transitions and states is correct after calling Rpp
 */
void TestRppNumberStatesTransitions();

/**
 * Test if the states are split into active and passive states and if the number of
 * states has been doubled.
 */
void TestNdaActivePassive();

/**
 * Test if transition start and end states are set as expected
 */
void TestNdaTransitions();

/**
 * All RenQ Tests
 */
void TestRenQ();

/**
 * All RenG tests.
 */
void TestRenG();

/**
 * All Rep0 tests
 */
void TestRep0();

/**
 * All Rpp tests
 */
void TestRpp();

/**
 * All Rep2 tests
 */
void TestRep2();

/**
 * All Nda tests
 */
void TestNda();


} // namespace faudes

#endif